using System.Windows.Forms;
using Microsoft.VisualBasic;
using System;
using StrataFlix.Business;


namespace StrataFlix
{
	public partial class MediaFormatSelection
	{
		
		#region " Constructors "
		
		/// <summary>
		/// Default Constructor
		/// </summary>
		/// <remarks></remarks>
		public MediaFormatSelection(string[] excludeItems)
		{
			
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			
			//-- Set the items to exlude
			cboFormats.EnumItemsToOmit = excludeItems;
			
			//-- Requery the list
			cboFormats.Requery();
		}
		
		#endregion
		
		#region " Handled Events "
		
		private void cmdOK_Click(object sender, System.EventArgs e)
		{
			DialogResult = System.Windows.Forms.DialogResult.OK;
		}
		
		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			DialogResult = System.Windows.Forms.DialogResult.Cancel;
		}
		
		private void cboFormats_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SetObjectStates();
		}
		
		#endregion
		
		#region " Private Methods "
		
		/// <summary>
		/// Set object states within the dialog
		/// </summary>
		/// <remarks></remarks>
		protected override void SetObjectStates()
		{
			this.cmdOK.Enabled = cboFormats.SelectedIndex > 0;
		}
		
		#endregion
		
		#region " Public Properties "
		
		/// <summary>
		/// The media format selected by the end-user
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		public MovieMediaFormats SelectedMediaFormat
		{
			get
			{
				return ((MovieMediaFormats) cboFormats.SelectedValue);
			}
		}
		
		#endregion
		
	}
	
}
